-- Tabele z pliku LigaKreglarskaStrukturaZmianaMY.sql muszą zostać utworzone najpierw.

USE LigaKreglarskaZmiana;

CREATE PROCEDURE R15_oblicz_sredni_hcp_wedlug_liczby_kregli()
UPDATE    Kreglarze
SET              LiczbaZbitychKregli =
                          (SELECT     SUM(WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), LiczbaRozegranychGier =
                          (SELECT     COUNT(Wyniki_kreglarzy.WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), BiezacaSredniaKreglarza =
                          IfNull((SELECT     Round(AVG(Wyniki_kreglarzy.WynikCzysty), 0)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), 0), BiezacyHandicapKreglarza =
                          IfNull((SELECT     Round(0.9 * (200 - Round(AVG(Wyniki_kreglarzy.WynikCzysty), 0)), 0)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), 0);

CREATE VIEW R15_oblicz_sredni_hcp_wedlug_liczby_kregli_zapytanie
AS 
SELECT Kreglarze.IDKreglarza, Kreglarze.LiczbaZbitychKregli, 
                          (SELECT     SUM(WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) 
AS NowaLiczbaZbitychKregli, Kreglarze.LiczbaRozegranychGier, 
                          (SELECT     COUNT(Wyniki_kreglarzy.WynikCzysty)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza) 
AS NowaLiczbaRozegranychGier, Kreglarze.BiezacaSredniaKreglarza, 
                          IfNull((SELECT     Round(AVG(Wyniki_kreglarzy.WynikCzysty), 0)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), 0) 
AS NowaBiezacaSredniaKreglarza, Kreglarze.BiezacyHandicapKreglarza, 
                          IfNull((SELECT     Round(0.9 * (200 - Round(AVG(Wyniki_kreglarzy.WynikCzysty), 0)), 0)
                            FROM          Wyniki_kreglarzy
                            WHERE      Wyniki_kreglarzy.IDKreglarza = Kreglarze.IDKreglarza), 0) 
AS NowyBiezacyHandicapKreglarza
FROM Kreglarze;

CREATE PROCEDURE R15_zmiana_nazwy_druzyny_Huckleberrys()
UPDATE    Druzyny
SET              NazwaDruzyny = 'Manta Rays'
WHERE     (NazwaDruzyny = 'Huckleberrys');

CREATE VIEW R15_zmiana_nazwy_druzyny_Huckleberrys_zapytanie
AS 
SELECT Druzyny.NazwaDruzyny, 'Manta Rays' AS NowaNazwaDruzyny
FROM Druzyny
WHERE Druzyny.NazwaDruzyny = 'Huckleberrys';

CREATE PROCEDURE R15_zmiana_lokalizacji_turnieju()
UPDATE    Turnieje
SET              LokalizacjaTurnieju = 'Oasis Lanes'
WHERE     (LokalizacjaTurnieju = 'Sports World Lanes');

CREATE VIEW R15_zmiana_lokalizacji_turnieju_zapytanie
AS 
SELECT Turnieje.IDTurnieju, Turnieje.LokalizacjaTurnieju, 'Oasis Lanes' AS NowaLokalizacjaTurnieju
FROM Turnieje
WHERE (Turnieje.LokalizacjaTurnieju = 'Sports World Lanes');

CREATE PROCEDURE R15_zaktualizuj_stan_i_miasto_zamieszkania_kreglarzy()
UPDATE    Kreglarze
SET              MiastoKreglarza =
                          (SELECT     Miasto
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod), StanZamKreglarza =
                          (SELECT     Stan
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod)
WHERE     (MiastoKreglarza <>
                          (SELECT     Miasto
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod)) OR
                      (StanZamKreglarza <>
                          (SELECT     Stan
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod));

CREATE VIEW R15_zaktualizuj_stan_i_miasto_zamieszkania_kreglarzy_zapytanie
AS 
SELECT Kreglarze.MiastoKreglarza, 
                          (SELECT     Miasto
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod) AS NoweMiastoKreglarza, Kreglarze.StanZamKreglarza, 
                          (SELECT     Stan
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod) AS NowyStanZamKreglarza
FROM Kreglarze
WHERE     (MiastoKreglarza <>
                          (SELECT     Miasto
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod)) OR
                      (StanZamKreglarza <>
                          (SELECT     Stan
                            FROM          KodyWaszyngton
                            WHERE      Kreglarze.KodPocztowyKreglarza = KodyWaszyngton.Kod));

CREATE PROCEDURE R16_dodaj_kreglarza()
INSERT INTO Kreglarze
                      (NazwiskoKreglarza, ImieKreglarza, AdresKreglarza, MiastoKreglarza, StanZamKreglarza, KodPocztowyKreglarza, TelefonKreglarza, IDDruzyny, LiczbaZbitychKregli, 
                      LiczbaRozegranychGier, BiezacaSredniaKreglarza, BiezacyHandicapKreglarza)
SELECT     NazwiskoKreglarza, 'Matthew' AS ImieKreglarza, AdresKreglarza, MiastoKreglarza, StanZamKreglarza, KodPocztowyKreglarza, TelefonKreglarza, IDDruzyny, 0 AS LiczbaZbitychKregli, 0 AS LiczbaRozegranychGier, 0 AS BolwerCurrentAverage, 0 AS BiezacyHandicapKreglarza
FROM         Kreglarze
WHERE     (NazwiskoKreglarza = 'Patterson') AND (ImieKreglarza = 'Neil');

CREATE VIEW R16_dodaj_kreglarza_zapytanie
AS 
SELECT Kreglarze.NazwiskoKreglarza, 'Matthew' AS ImieKreglarza, Kreglarze.AdresKreglarza, Kreglarze.MiastoKreglarza, Kreglarze.StanZamKreglarza, Kreglarze.KodPocztowyKreglarza, Kreglarze.TelefonKreglarza, Kreglarze.IDDruzyny, 0 AS LiczbaZbitychKregli, 0 AS LiczbaRozegranychGier, 0 AS BiezacaSredniaKreglarza, 0 AS BiezacyHandicapKreglarza
FROM Kreglarze
WHERE (((Kreglarze.NazwiskoKreglarza)='Patterson') AND ((Kreglarze.ImieKreglarza)='Neil'));

CREATE PROCEDURE R16_dodaj_druzyne()
INSERT INTO Druzyny
                      (NazwaDruzyny, IDKapitana)
VALUES     ('Aardvarks', NULL);

CREATE VIEW R16_dodaj_druzyne_zapytanie
AS
SELECT 'Aardvarks' As NazwaDruzyny, Null As IDKapitana;

CREATE PROCEDURE R16_zarchiwizuj_turnieje_2017_1()
INSERT INTO Turnieje_archiwum
SELECT     IDTurnieju, DataTurnieju, LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) );

CREATE VIEW R16_zarchiwizuj_turnieje_2017_1_zapytanie
AS 
SELECT     IDTurnieju, DataTurnieju, LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) );

CREATE PROCEDURE R16_zarchiwizuj_turnieje_2017_2()
INSERT INTO Mecze_turniejowe_archiwum
SELECT     IDMeczu, IDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty
FROM         Mecze_turniejowe
WHERE     (IDTurnieju IN
                          (SELECT     IDTurnieju
                            FROM          Turnieje
                            WHERE      DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) ));

CREATE VIEW R16_zarchiwizuj_turnieje_2017_2_zapytanie
AS 
SELECT     IDMeczu, IDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty
FROM         Mecze_turniejowe
WHERE     (IDTurnieju IN
                          (SELECT     IDTurnieju
                            FROM          Turnieje
                            WHERE      DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) ));

CREATE PROCEDURE R16_zarchiwizuj_turnieje_2017_3()
INSERT INTO Gry_meczowe_archiwum
SELECT     IDMeczu, NumerGry, NULL AS WinTeam
FROM         Gry_meczowe
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) ));

CREATE VIEW R16_zarchiwizuj_turnieje_2017_3_zapytanie
AS 
SELECT     IDMeczu, NumerGry, NULL AS WinTeam
FROM         Gry_meczowe
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) ));

CREATE PROCEDURE R16_zarchiwizuj_turnieje_2017_4()
INSERT INTO Wyniki_kreglarzy_archiwum
SELECT     IDMeczu, NumerGry, IDKreglarza, WynikCzysty, WynikHandicap, GraWygrana
FROM         Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) ));

CREATE VIEW R16_zarchiwizuj_turnieje_2017_4_zapytanie
AS 
SELECT     IDMeczu, NumerGry, IDKreglarza, WynikCzysty, WynikHandicap, GraWygrana
FROM         Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) ));

CREATE PROCEDURE R16_skopiuj_turnieje_2017_1()
INSERT INTO Turnieje
                      (IDTurnieju, DataTurnieju, LokalizacjaTurnieju)
SELECT     IDTurnieju + 25 AS NowyIDTurnieju, Date_Add(DataTurnieju, Interval 728 Day) AS NowaDataTurnieju, LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) );

CREATE VIEW R16_skopiuj_turnieje_2017_1_zapytanie
AS 
SELECT     IDTurnieju + 25 AS NowyIDTurnieju, Date_Add(DataTurnieju, Interval 728 Day) AS NowaDataTurnieju, LokalizacjaTurnieju
FROM         Turnieje
WHERE     (DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) );

CREATE PROCEDURE R16_skopiuj_turnieje_2017_2()
INSERT INTO Mecze_turniejowe
                      (IDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty)
SELECT     IDTurnieju + 25 AS NowyIDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty
FROM         Mecze_turniejowe
WHERE Mecze_turniejowe.IDTurnieju IN
(SELECT IDTurnieju 
 FROM Turnieje
 WHERE Turnieje.DataTurnieju Between CAST('2017-01-01' AS DATE) AND CAST('2017-12-31' AS Date) );

CREATE VIEW R16_skopiuj_turnieje_2017_2_zapytanie
AS 
SELECT     IDTurnieju + 25 AS NowyIDTurnieju, Tory, IDDruzynyTorNieparzysty, IDDruzynyTorParzysty
FROM         Mecze_turniejowe
WHERE Mecze_turniejowe.IDTurnieju IN
(SELECT IDTurnieju 
 FROM Turnieje
 WHERE Turnieje.DataTurnieju Between CAST('2017-01-01' AS DATE) AND CAST('2017-12-31' AS Date) );

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_1()
DELETE FROM Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe_archiwum.IDMeczu
                            FROM          Mecze_turniejowe_archiwum));

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_1_zapytanie
AS 
SELECT * FROM Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe_archiwum.IDMeczu
                            FROM          Mecze_turniejowe_archiwum));

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_1_ZLE()
DELETE FROM Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) ));

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_1_ZLE_zapytanie
AS 
SELECT * FROM Wyniki_kreglarzy
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe.IDMeczu
                            FROM          Mecze_turniejowe INNER JOIN
                                                   Turnieje ON Turnieje.IDTurnieju = Mecze_turniejowe.IDTurnieju
                            WHERE      Turnieje.DataTurnieju BETWEEN CAST('2017-01-01' AS Date)  AND CAST('2017-12-31' AS Date) ));

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_2()
DELETE FROM Gry_meczowe
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe_archiwum.IDMeczu
                            FROM          Mecze_turniejowe_archiwum));

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_2_zapytanie
AS 
SELECT * FROM Gry_meczowe
WHERE     (IDMeczu IN
                          (SELECT     Mecze_turniejowe_archiwum.IDMeczu
                            FROM          Mecze_turniejowe_archiwum));

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_3()
DELETE FROM Mecze_turniejowe
WHERE     (IDMeczu IN
                          (SELECT     IDMeczu
                            FROM          Mecze_turniejowe_archiwum));

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_3_zapytanie
AS 
SELECT * FROM Mecze_turniejowe
WHERE     (IDMeczu IN
                          (SELECT     IDMeczu
                            FROM          Mecze_turniejowe_archiwum));

CREATE PROCEDURE R17_usun_zarchiwizowane_turnieje_2017_4()
DELETE FROM Turnieje
WHERE     (IDTurnieju IN
                          (SELECT     Turnieje_archiwum.IDTurnieju
                            FROM          Turnieje_archiwum));

CREATE VIEW R17_usun_zarchiwizowane_turnieje_2017_4_zapytanie
AS 
SELECT * FROM Turnieje
WHERE     (IDTurnieju IN
                          (SELECT     Turnieje_archiwum.IDTurnieju
                            FROM          Turnieje_archiwum));

CREATE PROCEDURE R17_usun_kreglarzy_bez_gier()
DELETE FROM Kreglarze
WHERE     (LiczbaRozegranychGier = 0);

CREATE VIEW R17_usun_kreglarzy_bez_gier_zapytanie
AS 
SELECT * FROM Kreglarze
WHERE     (LiczbaRozegranychGier = 0);

CREATE PROCEDURE R17_usun_kreglarzy_bez_gier_bezpiecznie()
DELETE FROM Kreglarze
WHERE     (IDKreglarza NOT IN
                          (SELECT     IDKreglarza
                            FROM          Wyniki_kreglarzy));

CREATE VIEW R17_usun_kreglarzy_bez_gier_bezpiecznie_zapytanie
AS 
SELECT * FROM Kreglarze
WHERE     (IDKreglarza NOT IN
                          (SELECT     IDKreglarza
                            FROM          Wyniki_kreglarzy));

CREATE PROCEDURE R17_usun_mecze_ktore_sie_nie_odbyly()
DELETE FROM Mecze_turniejowe
WHERE     (IDMeczu NOT IN
                          (SELECT     IDMeczu
                            FROM          Wyniki_kreglarzy))
	AND   (IDMeczu NOT IN
                          (SELECT     IDMeczu
                            FROM          Gry_meczowe));

CREATE VIEW R17_usun_mecze_ktore_sie_nie_odbyly_zapytanie
AS 
SELECT * FROM Mecze_turniejowe
WHERE     (IDMeczu NOT IN
                          (SELECT     IDMeczu
                            FROM          Wyniki_kreglarzy))
	AND   (IDMeczu NOT IN
                          (SELECT     IDMeczu
                            FROM          Gry_meczowe));

